% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isothermal_sensitivities.R
\name{get_isothermal_correlation}
\alias{get_isothermal_correlation}
\title{Parameter correlation for isothermal inactivation experiments}
\usage{
get_isothermal_correlation(model, exp_design, pars)
}
\arguments{
\item{model}{character defining the inactivation model according to the rules
in the \code{bioinactivation} package.}

\item{exp_design}{data.frame with two columns named \code{times} and 
\code{temperature} describing the experiment design.}

\item{pars}{list defining the model parameters according to the rules defined
in the \code{bioinactivation} package.}
}
\description{
Parameter correlation for isothermal inactivation experiments
}
\examples{

library(tidyverse)
time_profile <- seq(0, 50, length = 20)
Temp_profile <- seq(52.5,60, length = 3)

exp_design <- expand.grid(time_profile,Temp_profile) \%>\%
  rename(times = Var1, temperature = Var2)

pars <- list(temp_crit = 55,
             n = 1.5,
             k_b = 0.1)

get_isothermal_correlation("Peleg", exp_design, pars )

}
