% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dccm.gnm.R
\name{dccm.gnm}
\alias{dccm.egnm}
\alias{dccm.gnm}
\title{Dynamic Cross-Correlation from Gaussian Network Model}
\usage{
\method{dccm}{gnm}(x, ...)

\method{dccm}{egnm}(x, ...)
}
\arguments{
\item{x}{an object of class \sQuote{gnm} or \sQuote{egnm} as obtained from 
\code{\link{gnm}}.}

\item{...}{additional arguments (currently ignored).}
}
\value{
Returns a cross-correlation matrix.
}
\description{
Calculate the cross-correlation matrix from Gaussian network model normal 
modes analysis.
}
\details{
This function calculates the cross-correlation matrix from Gaussian network
model (GNM) normal modes analysis (NMA) obtained from \code{gnm}. It returns 
a matrix of residue-wise cross-correlations whose elements, Cij, may be 
displayed in a graphical representation frequently termed a dynamical 
cross-correlation map, or DCCM. (See more details in \code{help(dccm.nma)}).
}
\examples{
## Fetch stucture
pdb <- read.pdb( system.file("examples/1hel.pdb", package="bio3d") )
   
## Calculate normal modes
modes <- gnm(pdb)
   
## Calculate correlation matrix
cm <- dccm(modes)

## Plot correlation map
plot(cm, sse = pdb, contour = FALSE, col.regions = bwr.colors(20),
     at = seq(-1, 1, 0.1))

}
\author{
Xin-Qiu Yao & Lars Skjaerven
}
\references{
Bahar, I. et al. (1997) \emph{Folding Des.} \bold{2}, 173.
}
\seealso{
\code{\link{gnm}}, \code{\link{dccm.nma}}, \code{\link{dccm.enma}},
  \code{\link{plot.dccm}}.
}
\keyword{analysis}

