% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changeData.R
\name{changeData}
\alias{changeData}
\title{Creates a list containing the raster data sets concerning the number
of times the category of interest is present and the number of times
the category of interest changes during the time series.}
\usage{
changeData(x, nodata, category, spres, datacrs = NULL)
}
\arguments{
\item{x}{is the data, which must be a RasterStack,RasterBrick,SpatRaster or
data frame.}

\item{nodata}{is alphanumeric, which denotes no data in the data set.}

\item{category}{is the category of interest. The default is set to 1.}

\item{spres}{is a 1*2 vector indicating the spatial resolution of the data.
The default is set to c(1000,1000).}

\item{datacrs}{is the Coordinate Reference System (CRS) of the input data.}
}
\value{
The output from \code{\link{changeData}}
}
\description{
Creates a list containing the raster data sets concerning the number
of times the category of interest is present and the number of times
the category of interest changes during the time series.
}
\examples{
example_data <- terra::rast(system.file("external/Example_raster_Y.tif",package="binaryTimeSeries"))
no_data <- 2
cat_interest <- 1
data_res <- c(1000,1000)
data_prj <- "+proj=utm +zone=32 +datum=WGS84 +ellps=GRS80  +units=m +no_defs"
chdata_output <- changeData(x = example_data,nodata = no_data,
category = cat_interest,spres = data_res,datacrs = data_prj)

}
