% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NI.A2M.R
\name{NI.A2M}
\alias{NI.A2M}
\title{Find the optimal testing configuration for non-informative 
array testing with master pooling}
\usage{
NI.A2M(p, Se, Sp, group.sz, obj.fn, weights = NULL)
}
\arguments{
\item{p}{the probability of disease, which can be specified as an overall
probability of disease or a homogeneous vector of individual probabilities.}

\item{Se}{the sensitivity of the diagnostic test.}

\item{Sp}{the specificity of the diagnostic test.}

\item{group.sz}{a single group size (representing the row/column size)
for which to calculate the operating characteristics, or a range of group
(row/column) sizes over which to find the OTC.}

\item{obj.fn}{a list of objective functions which are minimized to find the
OTC. The expected number of tests per individual, "\kbd{ET}", will always 
be calculated. Additional options include "\kbd{MAR}" 
(the expected number of tests divided by the expected number of correct 
classifications, described in Malinovsky et al. (2016)), and "\kbd{GR}" 
(a linear combination of the expected number of tests, the number of 
misclassified negatives, and the number of misclassified positives, 
described in Graff & Roeloffs (1972)). See Hitt et al. (2018) at
\url{http://chrisbilder.com/grouptesting} for additional details.}

\item{weights}{a matrix of up to six sets of weights for the GR function. 
Each set of weights is specified by a row of the matrix.}
}
\value{
A list containing:
\item{prob}{the probability of disease, as specified by the user.}
\item{Se}{the sensitivity of the diagnostic test.}
\item{Sp}{the specificity of the diagnostic test.}
\item{opt.ET, opt.MAR, opt.GR}{a list for each objective function specified 
by the user, containing:
\describe{
\item{OTC}{a list specifying elements of the optimal testing configuration, 
which include:
\describe{
\item{Array.dim}{the row/column size for the second stage of testing.}
\item{Array.sz}{the overall array size used for the first stage of testing.}}}
\item{p.mat}{the matrix of individual probabilities.}
\item{ET}{the expected testing expenditure for the OTC.}
\item{value}{the value of the objective function per individual.}
\item{PSe}{the overall pooling sensitivity for the algorithm.
Further details are given under 'Details'.}
\item{PSp}{the overall pooling specificity for the algorithm.
Further details are given under 'Details'.}
\item{PPPV}{the overall pooling positive predictive value for the algorithm.
Further details are given under 'Details'.}
\item{PNPV}{the overall pooling negative predictive value for the algorithm.
Further details are given under 'Details'.}}}
}
\description{
Find the optimal testing configuration for
non-informative array testing with master pooling and
calculate the associated operating characteristics.
}
\details{
This function finds the OTC and computes the associated 
operating characteristics for non-informative array testing with 
master pooling. Array testing with master pooling involves testing 
all specimens in the array together in one group before any row or 
column groups are formed. This function uses only square arrays, 
which is the way array-based group testing is carried out
in most real-world applications. Operating characteristics calculated 
are expected number of tests, pooling sensitivity, pooling specificity, 
pooling positive predictive value, and pooling negative predictive value 
for the algorithm. See Hitt et al. (2018) at
\url{http://chrisbilder.com/grouptesting} or Kim et al. (2007) 
for additional details on the implementation of non-informative array
testing with master pooling.

The value(s) specified by \kbd{group.sz} represent the row/column size, which 
is used for the second stage of testing after the entire array is tested 
together in one group. If a single value is provided for \kbd{group.sz}, operating
characteristics will be calculated and no optimization will be performed.
If a range of group sizes is specified, the OTC will be found over all 
group sizes.

The displayed pooling sensitivity, pooling specificity, pooling positive 
predictive value, and pooling negative predictive value are weighted 
averages of the corresponding individual accuracy measures for all 
individuals within the initial group for a hierarchical algorithm.
Expressions for these averages are provided in the Supplementary 
Material for Hitt et al. (2018). These expressions are based on accuracy 
definitions given by Altman and Bland (1994a, 1994b).
}
\section{Note}{
 This function returns the pooling positive and negative
predictive values for all individuals in the array even though these
measures are diagnostic specific; i.e., PPV (NPV) should only be considered
for those individuals who have tested positive (negative).
}

\examples{
# Find the OTC for non-informative array testing with 
#   master pooling over a range of group (row/column) sizes.
# This example takes approximately 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
NI.A2M(p=0.04, Se=0.95, Sp=0.95, group.sz=3:10,
obj.fn=c("ET", "MAR"))

# Calculate the operating characteristics for a specified 
#   group (row/column) size for non-informative array 
#   testing with master pooling.
# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
NI.A2M(p=rep(0.01, 64), Se=0.90, Sp=0.90, group.sz=8,
obj.fn=c("ET", "MAR", "GR"),
weights=matrix(data=c(1,1,10,10), 
nrow=2, ncol=2, byrow=TRUE))
}
\references{
\insertRef{Altman1994a}{binGroup}

\insertRef{Altman1994b}{binGroup}

\insertRef{Graff1972}{binGroup}

\insertRef{Hitt2018}{binGroup}

\insertRef{Kim2007}{binGroup}

\insertRef{Malinovsky2016}{binGroup}
}
\seealso{
\code{\link{NI.Array}} for non-informative array testing without master 
pooling, \code{\link{Inf.Array}} for informative array testing without 
master pooling, and \code{\link{OTC}} for finding the optimal testing 
configuration for a number of standard group testing algorithms.

\url{http://chrisbilder.com/grouptesting}

Other OTC functions: \code{\link{Inf.Array}},
  \code{\link{Inf.D3}}, \code{\link{Inf.Dorf}},
  \code{\link{NI.Array}}, \code{\link{NI.D3}},
  \code{\link{NI.Dorf}}, \code{\link{OTC}}
}
\author{
Brianna D. Hitt
}
