% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_utils.R
\name{bb_colors_manual}
\alias{bb_colors_manual}
\title{Set colors for each datas}
\usage{
bb_colors_manual(bb, ..., opacity = 1)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{...}{A named list, where names correspond to the data, and values
to color associate with it.}

\item{opacity}{Color opacity (for area charts).}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Set colors for each datas
}
\examples{

library("RColorBrewer")

# Scatter
billboarder() \%>\% 
  bb_scatterplot(
   data = iris, 
   x = "Sepal.Length", 
   y = "Sepal.Width", 
   group = "Species"
  ) \%>\% 
  bb_axis(x = list(tick = list(fit = FALSE))) \%>\% 
  bb_point(r = 8) \%>\% 
  bb_colors_manual(
   setosa = "#440154", 
   virginica = "#21908C", 
   versicolor = "#FDE725"
  )

# Pie
stars <- data.frame(
  package = c("billboarder", "ggiraph", "officer",
              "shinyWidgets", "visNetwork"),
  stars = c(9, 177, 43, 44, 169)
)
cols <- brewer.pal(n = 5, name = "Dark2")

billboarder() \%>\% 
  bb_piechart(data = stars) \%>\% 
  bb_colors_manual(
   setNames(as.list(cols), stars$package) # this is a named list
  )
  
}
