# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' import_to_station_table
#'
#' Inserts data into the table of stations in the database. Applies to those
#' cities for which station data are included and read as part of the actual
#' raw trips data: ny, boston, la, philly.
#'
#' @param dbcon Active connection to sqlite3 database
#' @param stationqry Station query constructed during reading of data with
#'        rcpp_import_to_trip_table ()
#'
#' @return integer result code
#'
#' @noRd
NULL

#' get_bo_stn_table
#'
#' Because some data files for Boston contain only the names of stations
#' and not their ID numbers, a std::map is generated here mapping those names
#' onto IDs for easy insertion into the trips data table.
#'
#' @param dbcon Active connection to SQLite3 database
#'
#' @return std::map of <station name, station ID>
#'
#' @note The map is tiny, so it's okay to return values rather than refs
#'
#' @noRd
NULL

#' get_dc_stn_table
#'
#' Because some data files for Washington DC contain only the names of stations
#' and not their ID numbers, a std::map is generated here mapping those names
#' onto IDs for easy insertion into the trips data table.
#'
#' @param dbcon Active connection to SQLite3 database
#'
#' @return std::map of <station name, station ID>
#'
#' @note The map is tiny, so it's okay to return values rather than refs
#'
#' @noRd
NULL

#' get_dc_stn_ids
#'
#' Returns vector of all station IDs in the official DC Govt and Boston files.
#' Only trips from and to stations with codes in this file are loaded into db.
#'
#' @param dbcon Active connection to SQLite3 database
#'
#' @return std::unordered_set of <std::string station ID>
#'
#' @note The map is tiny, so it's okay to return values rather than refs
#'
#' @noRd
NULL

#' rcpp_import_stn_df
#'
#' Import a data.frame of station (id, name, lon, lat) into the SQLite3
#' database. Used for London and Chicago, for both of which stations are loaded
#' within R and passed to this function. The function also prepends the
#' two-character city ID to each station ID.
#'
#' @param dbcon Active connection to sqlite3 database
#' @param stn_data An R DataFrame of (id, name, lon, lat) for all stations
#'
#' @return Number of stations to potentially be added to stations table (if not
#'         already there).
#'
#' @noRd
rcpp_import_stn_df <- function(bikedb, stn_data, city) {
    .Call(`_bikedata_rcpp_import_stn_df`, bikedb, stn_data, city)
}

#' Examine the header line of the data file to map the records on to the
#' corresponding columns in the database. The database has the following fields
#' and column numbers:
#'    | number | field                   |
#'    | ----   | ----------------------- |
#'    | 0      | duration                |
#'    | 1      | start_time              |
#'    | 2      | end_time                |
#'    | 3      | start_station_id        |
#'    | 4      | start_station_name      |
#'    | 5      | start_station_latitude  |
#'    | 6      | start_station_longitude |
#'    | 7      | end_station_id          |
#'    | 8      | end_station_name        |
#'    | 9      | end_station_latitude    |
#'    | 10     | end_station_longitude   |
#'    | 11     | bike_id                 |
#'    | 12     | user_type               |
#'    | 13     | birth_year              |
#'    | 14     | gender                  |
#' The HeaderStruct has vectors for "position" and "quoted". Each of these has
#' the same length as the number of entries in the actual file (not necessarily
#' equal to "num_db_fields = 15"), with "position" mapping each entry on to its
#' corresponding position in the database, and using -1 to denote no
#' corresponding field.
#' @noRd
NULL

#' get_field_quotes
#'
#' The quotation structure of the header line does not always reflect the
#' actual structure of the data, so the patterns of quotations are determined by
#' the first data line rather than in "get_field_positions".
#' @noRd
NULL

#' rcpp_import_to_trip_table
#'
#' Extracts bike data for NYC citibike
#' 
#' @param bikedb A string containing the path to the Sqlite3 database to 
#'        use. It will be created automatically.
#' @param datafiles A character vector containin the paths to the citibike 
#'        .csv files to import.
#' @param city First two letters of city for which data are to be added (thus
#'        far, "ny", "bo", "ch", "dc", and "la")
#' @param quiet If FALSE (0), progress is displayed on screen
#'
#' @return integer result code
#'
#' @noRd
rcpp_import_to_trip_table <- function(bikedb, datafiles, city, header_file_name, data_has_stations, quiet) {
    .Call(`_bikedata_rcpp_import_to_trip_table`, bikedb, datafiles, city, header_file_name, data_has_stations, quiet)
}

#' rcpp_import_to_file_table
#'
#' Creates and/or updates the table of datafile names in the database
#' 
#' @param bikedb A string containing the path to the Sqlite3 database to 
#'        use. 
#' @param datafiles List of names of files to be added - must be names of
#'        compressed \code{.zip} archives, not expanded \code{.csv} files
#' @param city Name of city associated with datafile
#'
#' @return Number of datafile names added to database table
#'
#' @noRd
rcpp_import_to_file_table <- function(bikedb, datafiles, city, nfiles) {
    .Call(`_bikedata_rcpp_import_to_file_table`, bikedb, datafiles, city, nfiles)
}

#' rcpp_create_sqlite3_db
#'
#' Initial creation of SQLite3 database
#' 
#' @param bikedb A string containing the path to the Sqlite3 database to 
#'        be created.
#'
#' @return integer result code
#'
#' @noRd
rcpp_create_sqlite3_db <- function(bikedb) {
    .Call(`_bikedata_rcpp_create_sqlite3_db`, bikedb)
}

#' rcpp_create_db_indexes
#'
#' Creates the specified indexes in the database to speed up queries. Note
#' that for the full dataset this may take some time.
#' 
#' @param bikedb A string containing the path to the sqlite3 database to use.
#' @param tables A vector with the tables for which to create indexes. This
#'        vector should be the same length as the cols vector.
#' @param cols A vector with the fields for which to create indexes.
#' @param reindex If false, indexes are created, otherwise they are simply
#'        reindexed.
#'
#' @return integer result code
#'
#' @noRd
rcpp_create_db_indexes <- function(bikedb, tables, cols, reindex) {
    .Call(`_bikedata_rcpp_create_db_indexes`, bikedb, tables, cols, reindex)
}

#' rcpp_create_city_index
#'
#' Creates city index in the database. This function is *always* run, while the
#' 'create_db_indexes' function is optionally run.
#' 
#' @param bikedb A string containing the path to the sqlite3 database to use.
#' @param reindex If false, indexes are created, otherwise they are simply
#'        reindexed.
#'
#' @return integer result code
#'
#' @noRd
rcpp_create_city_index <- function(bikedb, reindex) {
    .Call(`_bikedata_rcpp_create_city_index`, bikedb, reindex)
}

