% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data.R
\name{prepare_data}
\alias{prepare_data}
\title{Data preparation}
\usage{
prepare_data(y, X, type = "linear", candidates = NULL, Xadd = NULL,
  na = NULL, maxp = 1e+06, verbose = TRUE)
}
\arguments{
\item{y}{a numeric vector of dependent (target) variable.}

\item{X}{a numeric matrix or an object of class \code{big.matrix}. The
columns of \code{X} should contain dependent variables (predictors).}

\item{type}{a string, type of the regression model you want to fit. You can
use one of these: \code{"linear"}, \code{"logistic"}, \code{"poisson"}.}

\item{candidates}{a numeric vector, columns from \code{X} which will be used
in the selection procedure. The order is important. If \code{NULL}, every
column will be used.}

\item{Xadd}{a numeric matrix, additional variables which will be included in
the model selection procedure (they will not be removed in any step). If
\code{NULL}, \code{Xadd} will contain only a column of ones (the
intercept). If you specify \code{Xadd}, a column of ones will be
automatically added (it is impossible to not include the intercept).}

\item{na}{a logical. There are any missing values in \code{X}? If
\code{NULL}, it will be checked (it can take some time if \code{X} is big,
so it is reasonable to set it).}

\item{maxp}{a numeric. The matrix \code{X} will be splitted into parts with
\code{maxp} elements. It will not change results, but it is necessary if
your computer does not have enough RAM. Set to a lower value if you still
have problems.}

\item{verbose}{a logical. Set \code{FALSE} if you do not want to see any
information during the selection procedure.}
}
\value{
An object of class \code{big}.
}
\description{
Create an object of class \code{big} which is needed to perform the selection
procedure.
}
\details{
The function automatically removes observations which have missing
  values in \code{y}. Type \code{browseVignettes("bigstep")} for more
  details.
}
\examples{
X <- matrix(rnorm(20), ncol = 4)
y <- X[, 2] + rnorm(5)
data <- prepare_data(y, X)

}
