% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_conversions.r
\name{umolCO2.to.gC}
\alias{umolCO2.to.gC}
\alias{gC.to.umolCO2}
\title{Conversion between Mass and Molar Units of Carbon and CO2}
\usage{
umolCO2.to.gC(CO2_flux, constants = bigleaf.constants())

gC.to.umolCO2(C_flux, constants = bigleaf.constants())
}
\arguments{
\item{CO2_flux}{CO2 flux (umol CO2 m-2 s-1)}

\item{constants}{Cmol - molar mass of carbon (kg mol-1) \cr
umol2mol - conversion micromole (umol) to mol (mol) \cr
mol2umol - conversion mole (mol) to micromole (umol)  \cr
kg2g - conversion kilogram (kg) to gram (g) \cr
g2kg - conversion gram (g) to kilogram (kg) \cr
days2seconds - seconds per day}

\item{C_flux}{Carbon (C) flux (gC m-2 d-1)}
}
\description{
Converts CO2 quantities from umol CO2 m-2 s-1 to g C m-2 d-1 and vice versa.
}
\examples{
umolCO2.to.gC(20)  # gC m-2 d-1

}
