% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{bqr_create_table}
\alias{bqr_create_table}
\title{Create a Table}
\usage{
bqr_create_table(projectId = bq_get_global_project(),
  datasetId = bq_get_global_dataset(), tableId, template_data,
  timePartitioning = FALSE, expirationMs = 0L)
}
\arguments{
\item{projectId}{The BigQuery project ID.}

\item{datasetId}{A datasetId within projectId.}

\item{tableId}{Name of table you want.}

\item{template_data}{A dataframe with the correct types of data}

\item{timePartitioning}{Whether to create a partioned table}

\item{expirationMs}{If a partioned table, whether to have an expiration time on the data. The default \code{0} is no expiration.}
}
\value{
TRUE if created, FALSE if not.
}
\description{
Create a Table
}
\details{
Creates a BigQuery table.

If setting \code{timePartioning} to \code{TRUE} then the table will be a 
  \href{partioned table}{https://cloud.google.com/bigquery/docs/creating-partitioned-tables}
}
\seealso{
Other bigQuery meta functions: \code{\link{bqr_delete_table}},
  \code{\link{bqr_list_datasets}},
  \code{\link{bqr_list_projects}},
  \code{\link{bqr_list_tables}},
  \code{\link{bqr_table_data}},
  \code{\link{bqr_table_meta}}
}
