% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{setoptions}
\alias{setoptions}
\alias{set_default_options}
\alias{set_fallback_options}
\alias{set_fast_options}
\title{Set package options with regard to computation times}
\usage{
set_default_options()

set_fast_options()

set_fallback_options()
}
\value{
A list of modified options and their new values.
}
\description{
These functions set options of the bfast and strucchangeRcpp packages to enable
faster computations. By default (\code{set_default_options}), these optimizations are
enabled. Notice that only some functions of the \code{bfast}
package make use of these options. \code{set_fast_options} is an alias for \code{set_default_options}.
}
\examples{


# run bfastmonitor with different options and compare computation times
library(zoo)
NDVIa <- as.ts(zoo(som$NDVI.a, som$Time))

set_default_options()
\dontrun{
system.time(replicate(100,  bfastmonitor(NDVIa, start = c(2010, 13))))
}

set_fallback_options()
\dontrun{
system.time(replicate(100,  bfastmonitor(NDVIa, start = c(2010, 13))))
}

}
