% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bexy.R
\name{getSamplesWithAutosomalTrisomy}
\alias{getSamplesWithAutosomalTrisomy}
\title{Getting all samples classified as a certain autosomal trisomy}
\usage{
getSamplesWithAutosomalTrisomy(object, scaffoldName, threshold_certainty = 0.9)
}
\arguments{
\item{object}{A bexy object.}

\item{scaffoldName}{The scaffold name, must be an autosome.}

\item{threshold_certainty}{The threshold for certainty on the posterior probabilities. All samples that have a posterior probability less than this threshold are classified as 'uncertain'.}
}
\value{
A character vector containing all sample names that are classified as having an autosomal trisomy of scaffold 'scaffoldName'
}
\description{
Getting all samples classified as a certain autosomal trisomy
}
\examples{
bex <- bexy()
getSamplesWithAutosomalTrisomy(bex, "21")
}
\seealso{
\code{\link{bexy}}
}
