% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{Beta.2p.fit}
\alias{Beta.2p.fit}
\title{Method of Moment Estimates of Shape-Parameters of the Two-Parameter (Standard) Beta Distribution.}
\usage{
Beta.2p.fit(scores)
}
\arguments{
\item{scores}{A vector of values to which the two-parameter beta distribution is to be fitted. The values ought to fall within the [0, 1] interval.}
}
\value{
A list of parameter-values required to produce a four-parameter beta distribution with the same first four moments as the observed distribution.
}
\description{
An implementation of the method of moments estimation of two-parameter beta distribution parameters. Given a vector of values, calculates the shape- and location parameters required to produce a four-parameter beta distribution with the same mean, variance, skewness and kurtosis (i.e., the first four moments) as the observed-score distribution.
}
\examples{
# Generate some fictional data. Say, 100 individuals take a test with a
# maximum score of 100 and a minimum score of 0.
set.seed(1234)
testdata <- rbinom(100, 100, rBeta.4P(100, .25, .75, 5, 3)) / 100
hist(testdata, xlim = c(0, 1), freq = FALSE)

# To fit and retrieve the parameters for a two-parameter beta distribution
# to the observed-score distribution using Beta.2p.fit():
(params.2p <- Beta.2p.fit(testdata))
curve(dbeta(x, params.2p$alpha, params.2p$beta), add = TRUE)
}
