% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearPlot.R
\name{yearPlot}
\alias{yearPlot}
\title{annual plot}
\usage{
yearPlot(
  dates,
  values,
  data,
  ylim = NULL,
  shift = 0,
  janline = TRUE,
  add = FALSE,
  months = substr(month.abb, 1, 1),
  xlab = "",
  ylab = "",
  zlab = "",
  ...
)
}
\arguments{
\item{dates}{Dates, in any format coerced by \code{\link{as.Date}}.}

\item{values}{Values to be mapped in color with \code{\link{colPoints}}}

\item{data}{Optional: data.frame from which to use dates and values.}

\item{ylim}{(reverse) date range in numerical years. 
DEFAULT: NULL (computed from \code{dates} internally)}

\item{shift}{Number of days to move the year-break to.
E.g. shift=61 for German hydrological year (Nov to Oct). DEFAULT: 0}

\item{janline}{Logical: Should vertical line be plotted at
January 1st if \code{shift!=0}? DEFAULT: TRUE}

\item{add}{Logical. Add to existing plot? DEFAULT: FALSE}

\item{months}{Labels for the months. DEFAULT: J,F,M,A,M,J,J,A,S,O,N,D}

\item{xlab, ylab, zlab}{Axis and legend labels. DEFAULT: ""}

\item{\dots}{Further arguments passed to \code{\link{colPoints}} like
legend, pch, main, xaxs, ...}
}
\value{
invisible list with coordinates
}
\description{
Visualize seasonality of time series
}
\examples{
qfile <- system.file("extdata/discharge39072.csv", package="berryFunctions")
Q <- read.table(qfile, skip=19, header=TRUE, sep=",", fill=TRUE)[,1:2]
Q$data <- as.Date(Q$data)
yearPlot(data, last, data=Q)
yearPlot(as.Date(c("2011-06-07","2009-03-25")), 1:2, add=TRUE, pch=3, col=1, legend=FALSE)
yearPlot(data, last, data=Q, shift=61)
yearPlot(data, last, data=Q, ylim=c(2015,2001))

}
\seealso{
\code{\link{seasonality}}, \code{\link{colPoints}},
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Sept 2019
}
\keyword{aplot}
