% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiralDate.R
\name{spiralDate}
\alias{spiralDate}
\title{Spiral graph of time series}
\usage{
spiralDate(dates, values, data, drange = NA, vrange = NA,
  months = substr(month.abb, 1, 1), add = FALSE, shift = 0, prop = NA,
  zlab = substitute(values), format = "\%Y", nint = 1, ...)
}
\arguments{
\item{dates}{Dates in ascending order.
Can be character strings or \code{\link{strptime}} results,
as accepted (and coerced) by \code{\link{as.Date}}}

\item{values}{Values to be mapped in color with \code{\link{colPoints}} along seasonal spiral}

\item{data}{Optional: data.frame with the column names as given by dates and values}

\item{drange}{Optional date range (analogous to xlim), can be a vector like \code{dates}. DEFAULT: NA}

\item{vrange}{Optional value range (analogous to ylim), can be a vector like \code{values}. DEFAULT: NA}

\item{months}{Labels for the months. DEFAULT: J,F,M,A,M,J,J,A,S,O,N,D}

\item{add}{Add to existing plot? DEFAULT: FALSE}

\item{shift}{Number of days to move January 1st clockwise. DEFAULT: 0}

\item{prop}{Proportion of the data to be actually plotted, used in \code{\link{spiralDateAnim}}. DEFAULT: NA (ignored)}

\item{zlab}{Title of \code{\link{colPointsLegend}}}

\item{format}{Format of date labels see details in \code{\link{strptime}}. DEFAULT: "\%Y"}

\item{nint}{Number of interpolation segments between points,
only used if \code{lines=TRUE} (passed to \code{\link{colPoints}}).
DEFAULT: 1 (with long time series, the colPoints default of 30 is too high!)}

\item{\dots}{Further arguments passed to \code{\link{colPoints}}, but not Range (use \code{vrange})}
}
\value{
invisible data.frame with date, vals, and the plotting coordinates
}
\description{
Plot seasonality of (daily) time series along spiral
}
\examples{
# synthetic seasonal Data
set.seed(42)
fakeData <- data.frame(time = as.Date("1985-01-01")+0:5000,
                       vals = cumsum(rnorm(5001))+50          )
fakeData$vals <- fakeData$vals + sin(0:5000/366*2*pi)*max(abs(fakeData$vals))

sp <- spiralDate(time,vals, data=fakeData)
tail(sp)
spiralDate(time,vals, data=fakeData, drange=as.Date(c("1980-01-01", "2004-11-15")), lines=TRUE)

par(mfrow=c(1,3), mar=c(3,3,6,1), mgp=c(2,0.6,0), las=1)
colPoints(time,vals,vals, data=fakeData, col=divPal(100), add=FALSE, legend=FALSE,
          lines=TRUE, pch=NA, nint=1, lwd=2)
title(main="classical time series\\nworks badly for long time series\\nshows trends well")

seasonality(time, vals, fakeData, col=divPal(100), mar=c(3,3,6,1), legend=FALSE, main="", shift=61)
title(main="yearly time series\\nday of year over time\\nfails for cyclicity over all year")

spiralDate(time,vals, data=fakeData, col=divPal(100), legargs=list(y1=0.7,y2=0.8))
title(main="spiral graph\\nshows cyclic values nicely
            trends are harder to detect\\nrecent values = more visual weight")

par(mfrow=c(1,1))

# Data with missing values:
fakeData[1300:1500, 2] <- NA
spiralDate(time,vals, data=fakeData, lines=TRUE) # no problem
# Missing data:
fakeData <- na.omit(fakeData)
spiralDate(time,vals, data=fakeData, lines=TRUE) # problematic for lines
spiralDate(time,vals, data=fakeData, pch=3)      # but not for points

## Real data:
#library2("waterData")
#data(exampleWaterData)
#spiralDate(dates, val, data=q05054000LT, lines=TRUE, lwd=3)

}
\seealso{
\code{\link{seasonality}}, \code{\link{colPoints}}, \code{\link{as.Date}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2016
}
\keyword{aplot}
\keyword{chron}
\keyword{color}
\keyword{hplot}
