% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addFade.R
\name{addFade}
\alias{addFade}
\title{Color fade out}
\usage{
addFade(col, fade = 0.3, target = "white", ...)
}
\arguments{
\item{col}{Vector of color names (\code{\link{colors}}), hexadecimal or integer that can be interpreted by \code{\link{col2rgb}}}

\item{fade}{Level of fading towards target. between 0 (target) and 1 (col). Can also be a vector. DEFAULT: 0.3}

\item{target}{Target color that should be faded into. DEFAULT: "white"}

\item{\dots}{Further arguments passed to \code{\link{colorRamp}}}
}
\value{
character matirx with hexadecimal color codes.
}
\description{
Make existing colors fade away to white
}
\examples{

plot(1:11, pch=16, cex=3, col=addFade(2, 10:0/10))
plot(1:11, pch=16, cex=3, col=addFade(2, 10:0/10, target="blue"))
plot(1:11, pch=16, cex=3, col=addFade(2, 10:0/10, target=3:4))
plot(1:21, pch=16, cex=3, col=addFade(2:3, 10:0/10))
plot(1:21, pch=16, cex=3, col=addFade(2:3, 10:0/10, target=4:5))
NewColors <- addFade(c("red","blue","yellow","green", "purple"), 0:200/200)
plot(runif(1000), col=NewColors, pch=16, cex=2)

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Feb 2016
}
\seealso{
\code{\link{addAlpha}}, \code{\link{colorRamp}}, \code{\link{colors}}
}
\keyword{color}
\keyword{dplot}

