% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-BBC_pp.R
\docType{data}
\name{partypanelData}
\alias{partypanelData}
\alias{BBC_data}
\alias{BBC_pp15.1}
\alias{BBC_pp16.1}
\alias{BBC_pp17.1}
\alias{BBC_pp18.1}
\title{Subsets of Party Panel datasets}
\format{
For BBC_pp15.1, a \code{data.frame} with 123 columns and 829 rows.
For BBC_pp16.1, a \code{data.frame} with 63 columns and 1077 rows.
For BBC_pp17.1, a \code{data.frame} with 94 columns and 943 rows.
For BBC_pp18.1, a \code{data.frame} with 84 columns and 880 rows.
Note that many rows contain missing values; the columns and rows
were taken directly from the original Party Panel datasets, and
represent all participants that made it past a given behavior.
}
\usage{
data(BBC_pp15.1)

data(BBC_pp16.1)

data(BBC_pp17.1)

data(BBC_pp18.1)
}
\description{
These are subsets of Party Panel datasets. Party Panel is an annual
semi-panel determinant study among Dutch nightlife patrons, where every
year, the determinants of another nightlife-related risk behavior are
mapped.
}
\details{
The behaviors of the Party Panel waves were:
\itemize{
\item 2015: Behaviors related to using highly dosed ecstasy pills
\item 2016: Behaviors related to visiting nightlife first-aid facilities
\item 2017: Behaviors related to hearing protection
\item 2018: Behaviors related to flirting and boundary crossing
\item 2019: Behaviors related to sleeping hygiene surrounding nightlife participation
}

The full datasets are publicly available through the Open Science
Framework (https://osf.io/s4fmu/). Also see the GitLab
repositories (https://gitlab.com/partypanel) and the website
at https://partypanel.eu.
}
\examples{
data('BBC_pp17.1', package='behaviorchange');
behaviorchange::CIBERlite(data=BBC_pp17.1,
                          determinants=c("epw_attitude",
                                         "epw_perceivedNorm",
                                         "epw_pbc",
                                         "epw_habit"),
                          targets=c("epw_intention"));
}
\keyword{data}
