% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_graph_theme.R
\name{apply_graph_theme}
\alias{apply_graph_theme}
\title{Apply multiple DiagrammeR global graph attributes}
\usage{
apply_graph_theme(graph, ...)
}
\arguments{
\item{graph}{The \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph to apply the attributes to.}

\item{...}{One or more character vectors of length three, where the first element is
the attribute, the second the value, and the third, the attribute type (\code{graph},
\code{node}, or \code{edge}).}
}
\value{
The \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph.
}
\description{
Apply multiple DiagrammeR global graph attributes
}
\examples{
abcd_complete  <- behaviorchange::abcd(behaviorchange::abcd_specs_complete)$output$graph;
abcd_complete <- apply_graph_theme(abcd_complete,
                                   c("penwidth", 5, "node"),
                                   c("penwidth", 15, "edge"));
}
