% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_beta_distr}
\alias{create_beta_distr}
\alias{create_distr_beta}
\title{Create a beta distribution}
\usage{
create_beta_distr(
  id = NA,
  alpha = 0,
  beta = 1,
  value = NA,
  lower = NA,
  upper = NA
)
}
\arguments{
\item{id}{the distribution's ID}

\item{alpha}{the alpha shape parameter,
a numeric value.
The value
of alpha must be at least 0.0.
For advanced usage, use the structure
as returned by \code{\link{create_alpha_param}}.}

\item{beta}{the beta shape parameter,
a numeric value.
The value
of beta must be at least 1.0.
For advanced usage, use the structure
as returned by \code{\link{create_beta_param}}.}

\item{value}{the initial value for the MCMC}

\item{lower}{the lower bound, the lowest possible value}

\item{upper}{an upper limit of the uniform distribution.
If the upper limits needs to be infinity, set \code{upper} to \code{Inf}.}
}
\value{
a beta distribution
}
\description{
Create a beta distribution
}
\examples{
check_empty_beautier_folder()

beta_distr <- create_beta_distr()

beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  input_filename = get_fasta_filename(),
  beast2_input_file,
  tree_prior = create_yule_tree_prior(
    birth_rate_distr = beta_distr
  )
)
file.remove(beast2_input_file)

remove_beautier_folder()
check_empty_beautier_folder()
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richèl J.C. Bilderbeek
}
