% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrca_prior_to_xml_taxonset.R
\name{mrca_prior_to_xml_taxonset}
\alias{mrca_prior_to_xml_taxonset}
\title{Creates the \code{taxonset} section in the prior section of the
distribution section of a BEAST2 XML parameter file.}
\usage{
mrca_prior_to_xml_taxonset(mrca_prior, taxa_names_with_ids = NULL)
}
\arguments{
\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{taxa_names_with_ids}{taxa names that already have received
an ID. Causes the XML to \code{idref} these}
}
\value{
lines of XML text
}
\description{
Creates the \code{taxonset} section in the prior section of the
distribution section of a BEAST2 XML parameter file.
}
\examples{
  # <taxonset id="all" spec="TaxonSet">
  #     <taxon id="626029_aco" spec="Taxon"/>
  #     <taxon id="630116_aco" spec="Taxon"/>
  #     <taxon id="630210_aco" spec="Taxon"/>
  #     <taxon id="B25702_aco" spec="Taxon"/>
  #     <taxon id="61430_aco" spec="Taxon"/>
  # </taxonset>
}
\author{
Richèl J.C. Bilderbeek
}
