% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericPipe.R
\docType{class}
\name{GenericPipe}
\alias{GenericPipe}
\title{Abstract super classs that handles the management of the Pipes}
\usage{
GenericPipe
}
\description{
Provides the required methods to succesfully handle each
\code{\link{GenericPipe}} class.
}
\section{Constructor}{

\preformatted{
GenericPipe$new(propertyName,
                alwaysBeforeDeps,
                notAfterDeps)
}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
}
}
}
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
abstract method to preprocess the \code{\link{Instance}}.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preprocess.
}
}
}
}
}

\item{\bold{getPropertyName:}}{
gets of name of property.
\itemize{
\item{\emph{Usage:}}{
\code{getPropertyName()}
}
\item{\emph{Value:}}{
value of name of property.
}
}
}

\item{\bold{getAlwaysBeforeDeps:}}{
gets of the dependences always before.
\itemize{
\item{\emph{Usage:}}{
\code{getAlwaysBeforeDeps()}
}
\item{\emph{Value:}}{
value of dependences always before.
}
}
}

\item{\bold{getNotAfterDeps:}}{
gets of the dependences not after.
\itemize{
\item{\emph{Usage:}}{
\code{getNotAfterDeps()}
}
\item{\emph{Value:}}{
value of dependences not after.
}
}
}

\item{\bold{setPropertyName:}}{
changes the value of property's name.
\itemize{
\item{\emph{Usage:}}{
\code{setPropertyName(propertyName)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) the new value of the property's name.
}
}
}
}
}

\item{\bold{setAlwaysBeforeDeps:}}{
changes the value of dependencies always before.
\itemize{
\item{\emph{Usage:}}{
\code{setAlwaysBeforeDeps(alwaysBeforeDeps)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the new value of the dependencies always before.
}
}
}
}
}

\item{\bold{setNotAfterDeps:}}{
changes the value of dependencies not after.
\itemize{
\item{\emph{Usage:}}{
\code{setNotAfterDeps(notAfterDeps)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{notAfterDeps:}}{
(\emph{list}) the new value of the dependencies not after.
}
}
}
}
}

}
}

\section{Private fields}{

\itemize{
\item{\bold{propertyName:}}{
(\emph{character}) the name of property.
}
\item{\bold{alwaysBeforeDeps:}}{
(\emph{list}) dependencies of the type alwaysBefore. These dependences indicate
what Pipes must be executed before the current one.
}
\item{\bold{notAfterDeps:}}{
(\emph{list}) dependencies of the type notAfter. These dependences indicate what
Pipes must not be executed after the current one.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{ResourceHandler}},
         \code{\link{SlangPipe}}, \code{\link{StopWordPipe}},
         \code{\link{StoreFileExtPipe}}, \code{\link{TargetAssigningPipe}},
         \code{\link{TeeCSVPipe}}, \code{\link{ToLowerCasePipe}}
}
