% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StoreFileExtPipe.R
\docType{class}
\name{StoreFileExtPipe}
\alias{StoreFileExtPipe}
\title{Class to get the file's extension field of an Instance}
\usage{
StoreFileExtPipe
}
\description{
Gets the extension of a file. Creates the \strong{extension}
property which indicates extension of the file.
}
\section{Constructor}{

\preformatted{
StoreFileExtPipe$new(propertyName = "extension",
                     alwaysBeforeDeps = list(),
                     notAfterDeps = list())
}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
}
}
}
}

\section{Note}{

\code{\link{StoreFileExtPipe}} will automatically invalidate the
\code{\link{Instance}} if it is not able to find the
extension from the path field.
}

\section{Inherit}{

This class inherits from \code{\link{PipeGeneric}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain the extension of \code{\link{Instance}}.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preprocess.
}
}
}
}
}

\item{\bold{obtainExtension:}}{
gets of extension of the path.
\itemize{
\item{\emph{Usage:}}{
\code{obtainExtension(path)}
}
\item{\emph{Value:}}{
extension of the path.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) path of the file to get the extension.
}
}
}
}
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{PipeGeneric}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{TargetAssigningPipe}},
         \code{\link{TeeCSVPipe}}, \code{\link{ToLowerCasePipe}}
}
