% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_unit_localities.R
\name{get_unit_localities}
\alias{get_unit_localities}
\title{Get unit locality codes.}
\usage{
get_unit_localities(parentId, sort = c("id", "-id", "name", "-name"),
  lang = c("pl", "en"), ...)
}
\arguments{
\item{parentId}{A 12 character NUTS id code of parent unit.
Use \code{\link{search_units}} to find unit id code.}

\item{sort}{A type of sorting, "id" (default), "-id", "name", "-name"}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A dataset as a tibble.
}
\description{
Retrieve unit locality codes.
}
\details{
To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
 \donttest{
    get_unit_localities("030210106062")
}
}
\keyword{localities}
\keyword{search}
\keyword{units}
\keyword{utilities}
