% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.coxphgmfr.R
\name{print.coxphgmfr}
\alias{print.coxphgmfr}
\title{Print coxphgmfr}
\usage{
\method{print}{coxphgmfr}(x, ...)
}
\arguments{
\item{x}{A class \code{coxphgmfr} object.}

\item{...}{ignored}
}
\value{
An object of \code{print.coxphgmfr}, with some more human-readable results from \code{bcfrailph} object.
}
\description{
Generics to print the S3 class coxphgmfr.
}
\details{
Calls \code{print.coxphgmfr()}.
}
\note{
The summary function is currently identical to the print function.
}
\examples{
set.seed(2)
n1=600;IID=array(1:n1)
X1<-runif(n1,  min=0, max=1)
z=rgamma(n1,shape=2,scale=0.5)
u1<-runif(n1,  min=0, max=1)
time<- 1/0.1*log(1-0.1*log(u1)/(0.0001*exp(3*X1)*z))
censor=rep(1,n1)
dataa <- data.frame(time=time, X1=X1,censor=censor,IID=IID)

fitcoxfr=coxphgmfr(Surv(time,censor)~ X1+frailty(IID) ,data=dataa)
fitcoxfr

}
\seealso{
\code{\link{coxphgmfr}}
}
