% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{dAllIndicators.HDP}
\alias{dAllIndicators.HDP}
\title{Get the probabilities of all possible values of the hidden indicator variables of an "HDP" object.}
\usage{
\method{dAllIndicators}{HDP}(obj, j, x = NULL, ...)
}
\arguments{
\item{obj}{A "HDP" object.}

\item{j}{integer, the group ID.}

\item{x}{the observation. The data type of x must fit the observation distribution specified by "H0aF" when initiating the "HDP" object.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a data.frame of three columns, the first two columns are all possible values of z and k, the third column is the corresponding probabilities.
}
\description{
Get p(z,k|gamma,alpha,psi,j,x), or p(z,k|gamma,alpha,psi,j) for the model structure:
     \deqn{G|gamma \sim DP(gamma,U)}
     \deqn{pi_j|G,alpha \sim DP(alpha,G), j = 1:J}
     \deqn{z|pi_j \sim Categorical(pi_j)}
     \deqn{k|z,G \sim Categorical(G), \textrm{ if z is a sample from the base measure G}}
     \deqn{theta_k|psi \sim H0(psi)}
     \deqn{x|theta_k,k \sim F(theta_k)}
where DP(gamma,U) is a Dirichlet Process on positive integers, gamma is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(alpha,G) is a Dirichlet Process on integers with concentration parameter alpha and base measure G. The choice of F() and H0() can be described by an arbitrary "BasicBayesian" object such as "GaussianGaussian","GaussianInvWishart","GaussianNIW", "GaussianNIG", "CatDirichlet", and "CatDP". See \code{?BasicBayesian} for definition of "BasicBayesian" objects, and see for example \code{?GaussianGaussian} for specific "BasicBayesian" instances. As a summary, An "HDP" object is simply a combination of a "CatHDP" object (see \code{?CatHDP}) and an object of any "BasicBayesian" type.\cr
In the case of HDP, z and k can only be positive integers. \cr
This function will return all possible values of z, k and their corresponding probabilities
}
