% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{dPosteriorPredictive}
\alias{dPosteriorPredictive}
\title{Get the density value of the posterior predictive distribution}
\usage{
dPosteriorPredictive(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
numeric, the density value
}
\description{
This is a generic function that will generate the the density value of the posterior predictive distribution. i.e. for the model structure: \cr
     theta|gamma ~ H(gamma) \cr
     X|theta ~ F(theta) \cr
get the probability density/mass of the posterior predictive distribution of a new sample x_new: p(x_new|gamma).
}
\seealso{
\code{\link{dPosteriorPredictive.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{dPosteriorPredictive.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{dPosteriorPredictive.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{dPosteriorPredictive.CatDP}} for Categorical-DP conjugate structure ...
}
