% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{dPosteriorPredictive.HDP}
\alias{dPosteriorPredictive.HDP}
\title{Posterior predictive density function of a "HDP" object}
\usage{
\method{dPosteriorPredictive}{HDP}(obj, x = NULL, z, k, j, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "HDP" object.}

\item{x}{Random samples of the "BasicBayesian" object.}

\item{z}{integer.}

\item{k}{integer, the partition label of the parameter space where the observation x is drawn from.}

\item{j}{integer, group label.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector, the posterior predictive density.
}
\description{
Generate the the density value of the posterior predictive distribution of the following structure: \cr
     G_j|gamma ~ DP(gamma,U), j = 1:J \cr
     pi_j|G_j,alpha ~ DP(alpha,G_j) \cr
     z|pi_j ~ Categorical(pi_j) \cr
     k|z,G_j ~ Categorical(G_j), if z is a sample from the base measure G \cr
     theta_k|psi ~ H0(psi) \cr
     x|theta_k,k ~ F(theta_k) \cr
where DP(gamma,U) is a Dirichlet Process on positive integers, gamma is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G_j) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_j. The choice of F() and H0() can be arbitrary, they are distributions of x and theta_k correspondingly. \cr
In the case of HDP, z and k can only be positive integers. \cr
The model structure and prior parameters are stored in a "HDP" object. \cr
Posterior predictive is a distribution of x,z,k|gamma,alpha,psi or z,k|gamma,alpha,psi,x.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
@seealso \code{\link{HDP}}, \code{\link{dPosteriorPredictive.HDP}}, \code{\link{marginalLikelihood.HDP}}
}
