% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArchiveAsyncFrozen.R
\name{ArchiveAsyncFrozen}
\alias{ArchiveAsyncFrozen}
\title{Frozen Rush Data Storage}
\description{
Freezes the Redis data base of an \link{ArchiveAsync} to a  \code{data.table::data.table()}.
No further points can be added to the archive but the data can be accessed and analyzed.
Useful when the Redis data base is not permanently available.
Use the callback \link{bbotk.async_freeze_archive} to freeze the archive after the optimization has finished.
}
\section{S3 Methods}{

\itemize{
\item \code{as.data.table(archive)}\cr
\link{ArchiveAsync} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a tabular view of all performed function calls of the Objective.
The \code{x_domain} column is unnested to separate columns.
}
}

\examples{
# example only runs if a Redis server is available
if (mlr3misc::require_namespaces(c("rush", "redux", "mirai"), quietly = TRUE) &&
  redux::redis_available()) {
# define the objective function
fun = function(xs) {
  list(y = - (xs[[1]] - 2)^2 - (xs[[2]] + 3)^2 + 10)
}

# set domain
domain = ps(
  x1 = p_dbl(-10, 10),
  x2 = p_dbl(-5, 5)
)

# set codomain
codomain = ps(
  y = p_dbl(tags = "maximize")
)

# create objective
objective = ObjectiveRFun$new(
  fun = fun,
  domain = domain,
  codomain = codomain,
  properties = "deterministic"
)

# start workers
rush::rush_plan(worker_type = "remote")
mirai::daemons(1)

# initialize instance
instance = oi_async(
  objective = objective,
  terminator = trm("evals", n_evals = 20),
  callback = clbk("bbotk.async_freeze_archive")
)

# load optimizer
optimizer = opt("async_random_search")

# trigger optimization
optimizer$optimize(instance)

# frozen archive
instance$archive

# best performing configuration
instance$archive$best()

# covert to data.table
as.data.table(instance$archive)
}
}
\seealso{
\link{ArchiveAsync}
}
\section{Super classes}{
\code{\link[bbotk:Archive]{bbotk::Archive}} -> \code{\link[bbotk:ArchiveAsync]{bbotk::ArchiveAsync}} -> \code{ArchiveAsyncFrozen}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{data}}{(\link[data.table:data.table]{data.table::data.table})\cr
Data table with all finished points.}

\item{\code{queued_data}}{(\link[data.table:data.table]{data.table::data.table})\cr
Data table with all queued points.}

\item{\code{running_data}}{(\link[data.table:data.table]{data.table::data.table})\cr
Data table with all running points.}

\item{\code{finished_data}}{(\link[data.table:data.table]{data.table::data.table})\cr
Data table with all finished points.}

\item{\code{failed_data}}{(\link[data.table:data.table]{data.table::data.table})\cr
Data table with all failed points.}

\item{\code{n_queued}}{(\code{integer(1)})\cr
Number of queued points.}

\item{\code{n_running}}{(\code{integer(1)})\cr
Number of running points.}

\item{\code{n_finished}}{(\code{integer(1)})\cr
Number of finished points.}

\item{\code{n_failed}}{(\code{integer(1)})\cr
Number of failed points.}

\item{\code{n_evals}}{(\code{integer(1)})\cr
Number of evaluations stored in the archive.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ArchiveAsyncFrozen-new}{\code{ArchiveAsyncFrozen$new()}}
\item \href{#method-ArchiveAsyncFrozen-push_points}{\code{ArchiveAsyncFrozen$push_points()}}
\item \href{#method-ArchiveAsyncFrozen-pop_point}{\code{ArchiveAsyncFrozen$pop_point()}}
\item \href{#method-ArchiveAsyncFrozen-push_running_point}{\code{ArchiveAsyncFrozen$push_running_point()}}
\item \href{#method-ArchiveAsyncFrozen-push_result}{\code{ArchiveAsyncFrozen$push_result()}}
\item \href{#method-ArchiveAsyncFrozen-push_failed_point}{\code{ArchiveAsyncFrozen$push_failed_point()}}
\item \href{#method-ArchiveAsyncFrozen-data_with_state}{\code{ArchiveAsyncFrozen$data_with_state()}}
\item \href{#method-ArchiveAsyncFrozen-clear}{\code{ArchiveAsyncFrozen$clear()}}
\item \href{#method-ArchiveAsyncFrozen-clone}{\code{ArchiveAsyncFrozen$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="format"><a href='../../bbotk/html/Archive.html#method-Archive-format'><code>bbotk::Archive$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="help"><a href='../../bbotk/html/Archive.html#method-Archive-help'><code>bbotk::Archive$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="print"><a href='../../bbotk/html/Archive.html#method-Archive-print'><code>bbotk::Archive$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="best"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-best'><code>bbotk::ArchiveAsync$best()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="nds_selection"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-nds_selection'><code>bbotk::ArchiveAsync$nds_selection()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFrozen-new"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFrozen-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFrozen$new(archive)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{archive}}{(\link{ArchiveAsync})\cr
The archive to freeze.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFrozen-push_points"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFrozen-push_points}{}}}
\subsection{Method \code{push_points()}}{
Push queued points to the archive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFrozen$push_points(xss)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xss}}{(list of named \code{list()})\cr
List of named lists of point values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFrozen-pop_point"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFrozen-pop_point}{}}}
\subsection{Method \code{pop_point()}}{
Pop a point from the queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFrozen$pop_point()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFrozen-push_running_point"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFrozen-push_running_point}{}}}
\subsection{Method \code{push_running_point()}}{
Push running point to the archive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFrozen$push_running_point(xs, extra = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{(named \code{list})\cr
Named list of point values.}

\item{\code{extra}}{(\code{list()})\cr
Named list of additional information.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFrozen-push_result"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFrozen-push_result}{}}}
\subsection{Method \code{push_result()}}{
Push result to the archive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFrozen$push_result(key, ys, x_domain, extra = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{(\code{character()})\cr
Key of the point.}

\item{\code{ys}}{(\code{list()})\cr
Named list of results.}

\item{\code{x_domain}}{(\code{list()})\cr
Named list of transformed point values.}

\item{\code{extra}}{(\code{list()})\cr
Named list of additional information.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFrozen-push_failed_point"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFrozen-push_failed_point}{}}}
\subsection{Method \code{push_failed_point()}}{
Push failed point to the archive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFrozen$push_failed_point(key, message)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{(\code{character()})\cr
Key of the point.}

\item{\code{message}}{(\code{character()})\cr
Error message.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFrozen-data_with_state"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFrozen-data_with_state}{}}}
\subsection{Method \code{data_with_state()}}{
Fetch points with a specific state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFrozen$data_with_state(
  fields = c("xs", "ys", "xs_extra", "worker_extra", "ys_extra", "condition"),
  states = c("queued", "running", "finished", "failed"),
  reset_cache = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fields}}{(\code{character()})\cr
Fields to fetch.
Defaults to \code{c("xs", "ys", "xs_extra", "worker_extra", "ys_extra")}.}

\item{\code{states}}{(\code{character()})\cr
States of the tasks to be fetched.
Defaults to \code{c("queued", "running", "finished", "failed")}.}

\item{\code{reset_cache}}{(\code{logical(1)})\cr
Whether to reset the cache of the finished points.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFrozen-clear"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFrozen-clear}{}}}
\subsection{Method \code{clear()}}{
Clear all evaluation results from archive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFrozen$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncFrozen-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncFrozen-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncFrozen$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
