% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{predict,bbl-method}
\alias{predict,bbl-method}
\title{Predict Response Group Using \code{bbl} Model}
\usage{
\S4method{predict}{bbl}(object, newdata = NULL, logit = TRUE,
  useC = TRUE, verbose = 1, naive = FALSE, progress.bar = FALSE)
}
\arguments{
\item{object}{Object of class \code{bbl} containing trained model}

\item{newdata}{Data frame of new data for which prediction is to
be made. Columns must contain all of those in \code{model@data}.
If column names are present, the columns will be matched
based on them. Extra columns will be ignored. If column names
are not provided, the columns should exactly match
\code{model@data} predictor parts. If \code{NULL}, replaced
by \code{model@data} (self-prediction).}

\item{logit}{Return predictors whose logistic function gives probability;
otherwise return probability itself.}

\item{useC}{Use \code{C++} version for posterior probability computation.}

\item{verbose}{Verbosity level}

\item{naive}{Naive Bayes. Skip all interaction terms.}

\item{progress.bar}{Display progress of response group probability. Useful
for large samples.}
}
\value{
Matrix of predictors/posterior proabilities with samples in rows
and response groups in columns.
}
\description{
Make prediction of response group identity based on trained model
}
\details{
Will use new data set for predictors and trained \code{bbl} model
parameters and compute posterior probabilities of response group
identity.
}
\examples{
set.seed(154)

m <- 5
L <- 3
n <- 1000

predictors <- list()
for(i in 1:m) predictors[[i]] <- seq(0,L-1)
par0 <- randompar(predictors=predictors, h0=0, J0=0, dJ=0.5)
xi0 <- sample_xi(nsample=n, predictors=predictors, h=par0$h, J=par0$J) 

par1 <- randompar(predictors=predictors, h0=0.1, J0=0.1, dJ=0.5)
xi1 <- sample_xi(nsample=n, predictors=predictors, h=par1$h, J=par1$J) 

xi <- rbind(xi0,xi1)
y <- c(rep(0,n),rep(1,n))
dat <- cbind(data.frame(y=y),xi)
dat <- dat[sample(2*n),]
dtrain <- dat[seq(n),]
dtest <- dat[seq(n+1,2*n),]
ytest <- dtest[,'y']

model <- bbl(data=dtrain)
model <- train(model)

pred <- predict(object=model, newdata=dtest)
yhat <- apply(pred,1,which.max)-1
score <- mean(ytest==yhat)
score

auc <- pROC::roc(response=ytest, predictor=pred[,2], direction='<')$auc
auc
}
