% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_lik.R
\name{waic.varstan}
\alias{waic.varstan}
\alias{waic}
\title{Widely Applicable Information Criterion (WAIC)}
\usage{
\method{waic}{varstan}(x, ...)
}
\arguments{
\item{x}{A varstan object}

\item{...}{additional values need in waic methods}
}
\value{
An object of class \code{loo}. With the estimates of the
Watanabe-Akaike Information criteria.
}
\description{
Compute the widely applicable information criterion (WAIC)
based on the posterior likelihood using the \pkg{loo} package.
For more details see \code{\link[loo:waic]{waic}}.
}
\details{
See the \code{loo_compare} function of the \pkg{loo} package
for more details on model comparisons.
}
\examples{
\donttest{
 library(astsa)
 model = Sarima(birth,order = c(0,1,2),seasonal = c(1,1,1))
 fit1 = varstan(model,iter = 500,chains = 1)

 waic1 = waic(fit1)
 waic1
}

}
\references{
Vehtari, A., Gelman, A., & Gabry J. (2016). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC. \emph{In Statistics
and Computing}, \code{doi:10.1007/s11222-016-9696-4}.

Gelman, A., Hwang, J., & Vehtari, A. (2014). Understanding predictive
information criteria for Bayesian models. \emph{Statistics and Computing}.
24, 997-1016.

Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation
and widely applicable information criterion in singular learning theory.
\emph{The Journal of Machine Learning Research}. 11, 3571-3594.
}
