% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_read.R
\name{bayes_read_image}
\alias{bayes_read_image}
\title{Read probability maps}
\usage{
bayes_read_image(files)
}
\arguments{
\item{files}{Full path to raster files}
}
\value{
A SpatRaster object
}
\description{
Read probability maps
}
\examples{
if (bayes_run_examples()) {
# Define location of a probability file
data_dir <- system.file("/extdata/rgb", package = "bayesEO")
# list the file
files <- list.files(data_dir)
# build the full path
image_files <- paste0(data_dir, "/", files)
rgb_image <- bayes_read_image(image_files)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
