% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_plot.R
\name{bayes_plot_map}
\alias{bayes_plot_map}
\title{Plot labelled map}
\usage{
bayes_plot_map(
  x,
  legend = NULL,
  palette = "Spectral",
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  tmap_graticules_labels_size = 0.6,
  tmap_legend_title_size = 0.7,
  tmap_legend_text_size = 0.7,
  tmap_legend_bg_color = "white",
  tmap_legend_bg_alpha = 0.5,
  tmap_max_cells = 1e+06
)
}
\arguments{
\item{x}{SpatRaster to be plotted.}

\item{legend}{Named vector that associates labels to colors.}

\item{palette}{A sequential RColorBrewer palette}

\item{xmin}{Subset to be shown (xmin)}

\item{xmax}{Subset to be shown (xmax)}

\item{ymin}{Subset to be shown (ymin)}

\item{ymax}{Subset to be shown (ymax)}

\item{tmap_graticules_labels_size}{Size of graticules labels
(default: 0.7)}

\item{tmap_legend_title_size}{Size of legend title (default: 1.5)}

\item{tmap_legend_text_size}{Size of legend text (default: 1.2)}

\item{tmap_legend_bg_color}{Color of legend backgound
(default: "white")}

\item{tmap_legend_bg_alpha}{Transparency of legend background
(default: 0.5)}

\item{tmap_max_cells}{Maximum number of cells for tmap
(default = 1e+06)}
}
\value{
A plot object
}
\description{
Plot labelled map
}
\examples{
if (bayes_run_examples()) {
    # Define location of a probability file
    data_dir <- system.file("/extdata/probs",
                package = "bayesEO")
    # list the file
    file <- list.files(data_dir)
    # build the full path
    probs_file <- paste0(data_dir, "/", file)
    # define labels
    labels <- c("Water", "ClearCut_Burn", "ClearCut_Soil",
                "ClearCut_Veg", "Forest", "Wetland")

    probs_image <- bayes_read_probs(probs_file, labels)
    # Label the probs image
    y <- bayes_label(x)
    # produce a map of the labelled image
    bayes_plot_map(y)
}

}
\author{
Gilberto Camara \email{gilberto.camara@inpe.br}
}
