cols <- c(
  "game_pk",
  "game_date",
  "index",
  "startTime",
  "endTime",
  "isPitch",
  "type",
  "playId",
  "pitchNumber",
  "details.description",
  "details.event",
  "details.awayScore",
  "details.homeScore",
  "details.isScoringPlay",
  "details.hasReview",
  "details.code",
  "details.ballColor",
  "details.isInPlay",
  "details.isStrike",
  "details.isBall",
  "details.call.code",
  "details.call.description",
  "count.balls.start",
  "count.strikes.start",
  "count.outs.start",
  "player.id",
  "player.link",
  "pitchData.strikeZoneTop",
  "pitchData.strikeZoneBottom",
  "details.fromCatcher",
  "pitchData.coordinates.x",
  "pitchData.coordinates.y",
  "hitData.trajectory",
  "hitData.hardness",
  "hitData.location",
  "hitData.coordinates.coordX",
  "hitData.coordinates.coordY",
  "actionPlayId",
  "details.eventType",
  "details.runnerGoing",
  "position.code",
  "position.name",
  "position.type",
  "position.abbreviation",
  "battingOrder",
  "atBatIndex",
  "result.type",
  "result.event",
  "result.eventType",
  "result.description",
  "result.rbi",
  "result.awayScore",
  "result.homeScore",
  "about.atBatIndex",
  "about.halfInning",
  "about.inning",
  "about.startTime",
  "about.endTime",
  "about.isComplete",
  "about.isScoringPlay",
  "about.hasReview",
  "about.hasOut",
  "about.captivatingIndex",
  "count.balls.end",
  "count.strikes.end",
  "count.outs.end",
  "matchup.batter.id",
  "matchup.batter.fullName",
  "matchup.batter.link",
  "matchup.batSide.code",
  "matchup.batSide.description",
  "matchup.pitcher.id",
  "matchup.pitcher.fullName",
  "matchup.pitcher.link",
  "matchup.pitchHand.code",
  "matchup.pitchHand.description",
  "matchup.splits.batter",
  "matchup.splits.pitcher",
  "matchup.splits.menOnBase",
  "batted.ball.result",
  "home_team",
  "home_level_id",
  "home_level_name",
  "home_parentOrg_id",
  "home_parentOrg_name",
  "home_league_id",
  "home_league_name",
  "away_team",
  "away_level_id",
  "away_level_name",
  "away_parentOrg_id",
  "away_parentOrg_name",
  "away_league_id",
  "away_league_name",
  "batting_team",
  "fielding_team",
  "last.pitch.of.ab",
  "pfxId",
  "details.trailColor",
  "details.type.code",
  "details.type.description",
  "pitchData.startSpeed",
  "pitchData.endSpeed",
  "pitchData.zone",
  "pitchData.typeConfidence",
  "pitchData.plateTime",
  "pitchData.extension",
  "pitchData.coordinates.aY",
  "pitchData.coordinates.aZ",
  "pitchData.coordinates.pfxX",
  "pitchData.coordinates.pfxZ",
  "pitchData.coordinates.pX",
  "pitchData.coordinates.pZ",
  "pitchData.coordinates.vX0",
  "pitchData.coordinates.vY0",
  "pitchData.coordinates.vZ0",
  "pitchData.coordinates.x0",
  "pitchData.coordinates.y0",
  "pitchData.coordinates.z0",
  "pitchData.coordinates.aX",
  "pitchData.breaks.breakAngle",
  "pitchData.breaks.breakLength",
  "pitchData.breaks.breakY",
  "pitchData.breaks.spinRate",
  "pitchData.breaks.spinDirection",
  "hitData.launchSpeed",
  "hitData.launchAngle",
  "hitData.totalDistance",
  "injuryType",
  "umpire.id",
  "umpire.link",
  "details.isOut",
  "details.disengagementNum",
  "isBaseRunningPlay",
  "isSubstitution",
  "result.isOut",
  "about.isTopInning",
  "matchup.postOnFirst.id",
  "matchup.postOnFirst.fullName",
  "matchup.postOnFirst.link",
  "matchup.postOnSecond.id",
  "matchup.postOnSecond.fullName",
  "matchup.postOnSecond.link",
  "matchup.postOnThird.id",
  "matchup.postOnThird.fullName",
  "matchup.postOnThird.link"
)

test_that("MLB Play-by-Play", {
  skip_on_cran()
  
  x <- mlb_pbp(game_pk = 575156)
  
  expect_equal(colnames(x), cols)
  expect_s3_class(x, "data.frame")
})
