% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R
\docType{package}
\name{backbone}
\alias{backbone}
\alias{backbone-package}
\title{backbone: Extracts the Backbone from Graphs}
\description{
Provides methods for extracting from an unweighted and sparse subgraph (i.e., a backbone)
that contains only the most "important" edges in a weighted bipartite projection, a non-projection
weighted network, or an unweighted network.

Available backbone extraction functions include:
\itemize{
\item For weighted bipartite projections of weighted bipartite networks: \code{\link[=osdsm]{osdsm()}}.
\item For weighted bipartite projections of binary bipartite networks: \code{\link[=fixedfill]{fixedfill()}}, \code{\link[=fixedrow]{fixedrow()}}, \code{\link[=fixedcol]{fixedcol()}}, \code{\link[=sdsm]{sdsm()}}, and \code{\link[=fdsm]{fdsm()}}.
\item For non-projection weighted networks: \code{\link[=global]{global()}}, \code{\link[=disparity]{disparity()}}.
\item For unweighted networks: \code{\link[=sparsify]{sparsify()}}, \code{\link[=sparsify.with.skeleton]{sparsify.with.skeleton()}}, \code{\link[=sparsify.with.gspar]{sparsify.with.gspar()}}, \code{\link[=sparsify.with.lspar]{sparsify.with.lspar()}}, \code{\link[=sparsify.with.simmelian]{sparsify.with.simmelian()}}, \code{\link[=sparsify.with.jaccard]{sparsify.with.jaccard()}}, \code{\link[=sparsify.with.meetmin]{sparsify.with.meetmin()}}, \code{\link[=sparsify.with.geometric]{sparsify.with.geometric()}}, \code{\link[=sparsify.with.hypergeometric]{sparsify.with.hypergeometric()}}, \code{\link[=sparsify.with.localdegree]{sparsify.with.localdegree()}}, \code{\link[=sparsify.with.quadrilateral]{sparsify.with.quadrilateral()}}.
\item For all networks: \code{\link[=backbone.suggest]{backbone.suggest()}} will examine the data and suggest an appropriate backbone function
}

The package also includes some utility functions:
\itemize{
\item \code{\link[=fastball]{fastball()}} - Fast marginal-preserving randomization of binary matrices
\item \code{\link[=bicm]{bicm()}} - Compute probabilities under the bipartite configuration model
}

For additional documentation and background on the package functions, see \href{../doc/backbone.html}{\code{vignette("backbone")}}.
For updates, papers, presentations, and other backbone news, please see \href{https://www.zacharyneal.com/backbone}{www.rbackbone.net}
}
\references{
{Neal, Z. P. (2022). backbone: An R Package to Extract Network Backbones. \emph{PLOS ONE, 17}, e0269137. \doi{10.1371/journal.pone.0269137}}
}
