% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicm.R
\name{bicm}
\alias{bicm}
\title{Bipartite Configuration Model}
\usage{
bicm(M, fitness = FALSE, tol = 1e-08, max_steps = 200, ...)
}
\arguments{
\item{M}{matrix: a binary matrix}

\item{fitness}{boolean: FALSE returns a matrix of probabilities, TRUE returns a list of row and column fitnesses only}

\item{tol}{numeric, tolerance of algorithm}

\item{max_steps}{numeric, number of times to run \link{loglikelihood_prime_bicm} algorithm}

\item{...}{optional arguments}
}
\value{
a matrix of probabilities, or a list of fitnesses
}
\description{
\code{bicm} estimates cell probabilities under the bipartite configuration model
}
\details{
Given a binary matrix \strong{M}, the Bipartite Configuration Model (BiCM; Saracco et. al. 2015) returns a valued matrix
\strong{B} in which Bij is the \emph{approximate} probability that Mij = 1 in the space of all binary matrices with
the same row and column marginals as \strong{M}. The BiCM yields the closest approximations of the true probabilities
compared to other estimation methods (Neal et al., 2021), and is used by \code{\link[=sdsm]{sdsm()}} to extract the backbone of
a bipartite projection using the stochastic degree sequence model.

Optionally (if \code{fitness = TRUE}), \code{bicm()} instead returns a list of row and column fitnesses, which is faster and
requires less memory. Given the \emph{i}th row's fitness Ri and the \emph{j}th column's fitness Rj, the entry Bij in the
matrix can be computed as Ri\*Rj/(1+(Ri\*Rj)).

\strong{Note}: M cannot contain any rows or columns that contain all 0s or all 1s.
}
\examples{
M <- matrix(c(0,0,1,0,1,0,1,0,1),3,3)  #A binary matrix
bicm(M)
}
\references{
package: {Neal, Z. P. (2022). backbone: An R Package to Extract Network Backbones. \emph{PLOS ONE, 17}, e0269137. \doi{10.1371/journal.pone.0269137}}

bicm: {Saracco, F., Di Clemente, R., Gabrielli, A., & Squartini, T. (2015). Randomizing bipartite networks: The case of the World Trade Web. \emph{Scientific Reports, 5}, 10595. \doi{10.1038/srep10595}}
}
