% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{frommatrix}
\alias{frommatrix}
\title{Converts a backbone adjacency matrix to an object of specified class}
\usage{
frommatrix(graph, convert = "matrix")
}
\arguments{
\item{graph}{a matrix}

\item{convert}{class to convert to, one of "matrix", "sparseMatrix", "igraph", "edgelist", or "network"}
}
\value{
backbone graph: Binary or signed backbone graph of class given in parameter \code{convert}.
}
\description{
Converts a backbone adjacency matrix to an object of specified class
}
\examples{
M <- matrix(sample(c(-1,0,1),5*5,replace=TRUE),5,5)
test <- backbone:::frommatrix(M, "Matrix")
}
\keyword{internal}
