% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monolixControl.R
\name{monolixControl}
\alias{monolixControl}
\title{Monolix Controller for nlmixr2}
\usage{
monolixControl(
  nbSSDoses = 7,
  useLinearization = FALSE,
  stiff = FALSE,
  addProp = c("combined2", "combined1"),
  exploratoryAutoStop = FALSE,
  smoothingAutoStop = FALSE,
  burnInIterations = 5,
  smoothingIterations = 200,
  exploratoryIterations = 250,
  simulatedAnnealingIterations = 250,
  exploratoryInterval = 200,
  exploratoryAlpha = 0,
  omegaTau = 0.95,
  errorModelTau = 0.95,
  variability = c("none", "firstStage", "decreasing"),
  runCommand = getOption("babelmixr2.monolix", ""),
  rxControl = NULL,
  sumProd = FALSE,
  optExpression = TRUE,
  calcTables = TRUE,
  compress = TRUE,
  ci = 0.95,
  sigdigTable = NULL,
  absolutePath = FALSE,
  modelName = NULL,
  muRefCovAlg = TRUE,
  run = TRUE,
  ...
)
}
\arguments{
\item{nbSSDoses}{Number of steady state doses (default 7)}

\item{useLinearization}{Use linearization for log likelihood and
fim.}

\item{stiff}{boolean for using the stiff ODE solver}

\item{addProp}{specifies the type of additive plus proportional
  errors, the one where standard deviations add (combined1) or the
  type where the variances add (combined2).

The combined1 error type can be described by the following equation:

  \deqn{y = f + (a + b\times f^c) \times \varepsilon}{y = f + (a + b*f^c)*err}

The combined2 error model can be described by the following equation:

 \deqn{y = f + \sqrt{a^2 + b^2\times f^{2\times c}} \times \varepsilon}{y = f + sqrt(a^2 + b^2*(f^c)^2)*err}

 Where:

 - y represents the observed value

 - f represents the predicted value

 - a  is the additive standard deviation

 - b is the proportional/power standard deviation

 - c is the power exponent (in the proportional case c=1)}

\item{exploratoryAutoStop}{logical to turn on or off exploratory
phase auto-stop of SAEM (default 250)}

\item{smoothingAutoStop}{Boolean indicating if the smoothing should
automatically stop (default \code{FALSE})}

\item{burnInIterations}{Number of burn in iterations}

\item{smoothingIterations}{Number of smoothing iterations}

\item{exploratoryIterations}{Number of iterations for exploratory
phase (default 250)}

\item{simulatedAnnealingIterations}{Number of simulating annealing
iterations}

\item{exploratoryInterval}{Minimum number of iterations in the
exploratory phase (default 200)}

\item{exploratoryAlpha}{Convergence memory in the exploratory phase
(only used when \code{exploratoryAutoStop} is \code{TRUE})}

\item{omegaTau}{Proportional rate on variance for simulated
annealing}

\item{errorModelTau}{Proportional rate on error model for simulated
annealing}

\item{variability}{This describes the methodology for parameters
without variability.  It could be: - Fixed throughout (none) -
Variability in the first stage (firstStage) - Decreasing until it
reaches the fixed value (decreasing)}

\item{runCommand}{is a shell command or function to run monolix; You can specify
the default by
\code{options("babelmixr2.monolix"="runMonolix")}. If it is empty
and 'lixoftConnectors' is available, use lixoftConnectors to run
monolix. See details for function usage.}

\item{rxControl}{`rxode2` ODE solving options during fitting, created with `rxControl()`}

\item{sumProd}{Is a boolean indicating if the model should change
multiplication to high precision multiplication and sums to
high precision sums using the PreciseSums package.  By default
this is \code{FALSE}.}

\item{optExpression}{Optimize the rxode2 expression to speed up
calculation. By default this is turned on.}

\item{calcTables}{This boolean is to determine if the foceiFit
will calculate tables. By default this is \code{TRUE}}

\item{compress}{Should the object have compressed items}

\item{ci}{Confidence level for some tables.  By default this is
0.95 or 95\% confidence.}

\item{sigdigTable}{Significant digits in the final output table.
If not specified, then it matches the significant digits in the
`sigdig` optimization algorithm.  If `sigdig` is NULL, use 3.}

\item{absolutePath}{Boolean indicating if the absolute path should
be used for the monolix runs}

\item{modelName}{Model name used to generate the NONMEM output.  If
\code{NULL} try to infer from the model name (could be \code{x} if not
clear).  Otherwise use this character for outputs.}

\item{muRefCovAlg}{This controls if algebraic expressions that can
  be mu-referenced are treated as mu-referenced covariates by:

  1. Creating a internal data-variable `nlmixrMuDerCov#` for each
     algebraic mu-referenced expression

  2. Change the algebraic expression to `nlmixrMuDerCov# * mu_cov_theta`

  3. Use the internal mu-referenced covariate for saem

  4. After optimization is completed, replace `model({})` with old
  `model({})` expression

  5. Remove `nlmixrMuDerCov#` from nlmix2 output

In general, these covariates should be more accurate since it
changes the system to a linear compartment model.  Therefore, by default this is `TRUE`.}

\item{run}{Should monolix be run and the results be imported to nlmixr2?  (Default is TRUE)}

\item{...}{Ignored parameters}
}
\value{
A monolix control object
}
\description{
Monolix Controller for nlmixr2
}
\details{
If \code{runCommand} is given as a string, it will be called with the
\code{system()} command like:

\code{runCommand mlxtran}.

For example, if \code{runCommand="'/path/to/monolix/mlxbsub2021' -p "} then the command line
used would look like the following:

\code{'/path/to/monolix/mlxbsub2021' monolix.mlxtran}

If \code{runCommand} is given as a function, it will be called as
\code{FUN(mlxtran, directory, ui)} to run Monolix.  This allows you to run Monolix
in any way that you may need, as long as you can write it in R.  babelmixr2
will wait for the function to return before proceeding.

If \code{runCommand} is \code{NA}, \code{nlmixr()} will stop after writing
the model files and without starting Monolix.

Note that you can get the translated monolix components from a
parsed/compiled rxode2 ui object with \code{ui$monolixModel} and \code{ui$mlxtran}
}
\author{
Matthew Fidler
}
