% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_vpc_endpoint_service_permissions}
\alias{ec2_describe_vpc_endpoint_service_permissions}
\title{Describe Vpc Endpoint Service Permissions}
\usage{
ec2_describe_vpc_endpoint_service_permissions(
  ServiceId,
  DryRun = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{ServiceId}{Character. The ID of the service.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return for the request in a single page.[optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describes the principals (service
consumers) that are permitted to discover your VPC endpoint
service.
}
\section{ServiceId}{

The ID of the
service.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Filter}{


One or more filters.
\itemize{
\item \code{principal} - The ARN of the principal.
\item \code{principal-type} - The principal type (\code{All} \| \code{Service} \|
\code{OrganizationUnit} \| \code{Account} \| \code{User} \| \code{Role}).
}
}

\section{MaxResults}{

The maximum number of results to return for the
request in a single page. The remaining results of the initial request
can be seen by sending another request with the returned \code{NextToken}
value. This value can be between 5 and 1,000; if \code{MaxResults} is given a
value larger than 1,000, only 1,000 results are
returned.
}

