% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpn_tunnel_certificate}
\alias{ec2_modify_vpn_tunnel_certificate}
\title{Modify Vpn Tunnel Certificate}
\usage{
ec2_modify_vpn_tunnel_certificate(
  VpnConnectionId,
  VpnTunnelOutsideIpAddress,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpnConnectionId}{String. The ID of the AWS Site-to-Site VPN connection.}

\item{VpnTunnelOutsideIpAddress}{String. The external IP address of the VPN tunnel.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modifies the VPN tunnel endpoint
certificate.
}
\section{VpnConnectionId}{

The ID of the AWS
Site-to-Site VPN connection.
}

\section{VpnTunnelOutsideIpAddress}{

The external IP address
of the VPN tunnel.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

