% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_managed_prefix_list}
\alias{ec2_modify_managed_prefix_list}
\title{Modify Managed Prefix List}
\usage{
ec2_modify_managed_prefix_list(
  PrefixListId,
  DryRun = NULL,
  CurrentVersion = NULL,
  PrefixListName = NULL,
  AddEntry = NULL,
  RemoveEntry = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{PrefixListId}{String. The ID of the prefix list.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{CurrentVersion}{Integer. The current version of the prefix list.[optional]}

\item{PrefixListName}{String. A name for the prefix list.[optional]}

\item{AddEntry}{List. One or more entries to add to the prefix list.[optional]}

\item{RemoveEntry}{List. One or more entries to remove from the prefix list.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Managed Prefix List
}
\section{PrefixListId}{

The ID of the prefix
list.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{CurrentVersion}{

The current version of the
prefix list.
}

\section{PrefixListName}{

A name for the prefix
list.
}

\section{AddEntry}{

One or more entries to add to the prefix
list.
}

\section{RemoveEntry}{

One or more entries to remove from the prefix
list.
}

