% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_transit_gateway_route_tables}
\alias{ec2_describe_transit_gateway_route_tables}
\title{Describe Transit Gateway Route Tables}
\usage{
ec2_describe_transit_gateway_route_tables(
  TransitGatewayRouteTableIds = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayRouteTableIds}{List. The IDs of the transit gateway route tables.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one or more transit
gateway route tables. By default, all transit gateway route tables are
described. Alternatively, you can filter the
results.
}
\section{TransitGatewayRouteTableIds}{

The IDs of the transit
gateway route tables.
}

\section{Filter}{


One or more filters. The possible values are:
\itemize{
\item \code{default-association-route-table} - Indicates whether this is the
default association route table for the transit gateway (\code{true} \|
\code{false}).
\item \code{default-propagation-route-table} - Indicates whether this is the
default propagation route table for the transit gateway (\code{true} \|
\code{false}).
\item \code{state} - The state of the route table (\code{available} \| \code{deleting} \|
\code{deleted} \| \code{pending}).
\item \code{transit-gateway-id} - The ID of the transit gateway.
\item \code{transit-gateway-route-table-id} - The ID of the transit gateway
route table.
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

