% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_network_interface_attribute}
\alias{ec2_describe_network_interface_attribute}
\title{Describe Network Interface Attribute}
\usage{
ec2_describe_network_interface_attribute(
  NetworkInterfaceId,
  Attribute = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{NetworkInterfaceId}{String. The ID of the network interface.}

\item{Attribute}{String. The attribute of the network interface. This parameter is required.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes a network interface attribute. You
can specify only one attribute at a time.
}
\section{NetworkInterfaceId}{

The ID of the network
interface.
}

\section{Attribute}{

The attribute of the network interface.
This parameter is required.
}

\section{DryRun}{

Checks whether you have
the required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

