% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_internet_gateway}
\alias{ec2_delete_internet_gateway}
\title{Delete Internet Gateway}
\usage{
ec2_delete_internet_gateway(
  InternetGatewayId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InternetGatewayId}{String. The ID of the internet gateway.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes the specified internet gateway. You
must detach the internet gateway from the VPC before you can delete
it.
}
\section{InternetGatewayId}{

The ID of the internet
gateway.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

