% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_vpc_endpoint_connection_notification}
\alias{ec2_create_vpc_endpoint_connection_notification}
\title{Create Vpc Endpoint Connection Notification}
\usage{
ec2_create_vpc_endpoint_connection_notification(
  ConnectionNotificationArn,
  ConnectionEvents,
  DryRun = NULL,
  ServiceId = NULL,
  VpcEndpointId = NULL,
  ClientToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ConnectionNotificationArn}{String. The ARN of the SNS topic for the notifications.}

\item{ConnectionEvents}{List. One or more endpoint events for which to receive notifications.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ServiceId}{String. The ID of the endpoint service.[optional]}

\item{VpcEndpointId}{String. The ID of the endpoint.[optional]}

\item{ClientToken}{String. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Vpc Endpoint Connection Notification
}
\section{ConnectionNotificationArn}{

The ARN of the SNS topic for the
notifications.
}

\section{ConnectionEvents}{

One or more endpoint events for which
to receive notifications. Valid values are \code{Accept}, \code{Connect},
\code{Delete}, and \code{Reject}.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ServiceId}{

The ID of the endpoint
service.
}

\section{VpcEndpointId}{

The ID of the
endpoint.
}

\section{ClientToken}{

Unique, case-sensitive identifier that you
provide to ensure the idempotency of the request. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.
}

