% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_transit_gateway_vpc_attachment}
\alias{ec2_create_transit_gateway_vpc_attachment}
\title{Create Transit Gateway Vpc Attachment}
\usage{
ec2_create_transit_gateway_vpc_attachment(
  TransitGatewayId,
  VpcId,
  SubnetIds,
  Options = NULL,
  TagSpecifications = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayId}{String. The ID of the transit gateway.}

\item{VpcId}{String. The ID of the VPC.}

\item{SubnetIds}{List. The IDs of one or more subnets.}

\item{Options}{Object. The VPC attachment options.[optional]}

\item{TagSpecifications}{List. The tags to apply to the VPC attachment.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Transit Gateway Vpc Attachment
}
\section{TransitGatewayId}{

The ID of the transit
gateway.
}

\section{VpcId}{

The ID of the VPC.
}

\section{SubnetIds}{

The
IDs of one or more subnets. You can specify only one subnet per
Availability Zone. You must specify at least one subnet, but we
recommend that you specify two subnets for better availability. The
transit gateway uses one IP address from each specified
subnet.
}

\section{Options}{

The VPC attachment
options.
}

\section{TagSpecifications}{

The tags to apply to the VPC
attachment.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

