% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_spot_datafeed_subscription}
\alias{ec2_create_spot_datafeed_subscription}
\title{Create Spot Datafeed Subscription}
\usage{
ec2_create_spot_datafeed_subscription(
  Bucket,
  DryRun = NULL,
  Prefix = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Bucket}{String. The name of the Amazon S3 bucket in which to store the Spot Instance data feed.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Prefix}{String. The prefix for the data feed file names.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Creates a data feed for Spot Instances, enabling
you to view Spot Instance usage logs. You can create one data feed per
AWS account. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html}{Spot Instance data feed}
in the \emph{Amazon EC2 User Guide for Linux Instances}.
}
\section{Bucket}{

The name
of the Amazon S3 bucket in which to store the Spot Instance data feed.
For more information about bucket names, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules}{Rules for bucket naming}
in the \emph{Amazon S3 Developer Guide}.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{Prefix}{

The prefix
for the data feed file names.
}

