% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_network_interface_permission}
\alias{ec2_create_network_interface_permission}
\title{Create Network Interface Permission}
\usage{
ec2_create_network_interface_permission(
  NetworkInterfaceId,
  Permission,
  AwsAccountId = NULL,
  AwsService = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{NetworkInterfaceId}{String. The ID of the network interface.}

\item{Permission}{String. The type of permission to grant.}

\item{AwsAccountId}{String. The AWS account ID.[optional]}

\item{AwsService}{String. The AWS service. Currently not supported.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Network Interface Permission
}
\section{NetworkInterfaceId}{

The ID of the network
interface.
}

\section{Permission}{

The type of permission to
grant.
}

\section{AwsAccountId}{

The AWS account ID.
}

\section{AwsService}{

The
AWS service. Currently not supported.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

