% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_attach_internet_gateway}
\alias{ec2_attach_internet_gateway}
\title{Attach Internet Gateway}
\usage{
ec2_attach_internet_gateway(
  InternetGatewayId,
  VpcId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InternetGatewayId}{String. The ID of the internet gateway.}

\item{VpcId}{String. The ID of the VPC.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Attaches an internet gateway or a virtual private
gateway to a VPC, enabling connectivity between the internet and the
VPC. For more information about your VPC and internet gateway, see the
\href{https://docs.aws.amazon.com/vpc/latest/userguide/}{Amazon Virtual Private Cloud User Guide}.
}
\section{InternetGatewayId}{

The ID of the internet
gateway.
}

\section{VpcId}{

The ID of the
VPC.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

