% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tandem_id_from_genome_id.R
\name{get_tandem_id_from_genome_id}
\alias{get_tandem_id_from_genome_id}
\title{Get tandem repeat from genome}
\usage{
get_tandem_id_from_genome_id(
  genome_id,
  seed_id = FALSE,
  tandem_seq = FALSE,
  tandem_pos = FALSE,
  triplestore
)
}
\arguments{
\item{genome_id}{Integer or a list of integer values.}

\item{seed_id}{Integer (from 1 to 1000), a vector of integer values, or a
logical value. This integer is used for starting the pseudo-random number
generator that represents the environment experiencing a digital organism.
If a logical value is used, TRUE returns data found in all environments and
FALSE (by default) returns only distinct data regardless of the seed.}

\item{tandem_seq}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{tandem_pos}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{triplestore}{Object of class triplestore_access which manages database
access.}
}
\value{
Data frame. Columns: "seed_id" (optional), "genome_id", "tandem_id",
"tandem_seq" (optional), "tandem_pos" (optional).
}
\description{
Get the tandem repeat contained in the transcriptome of a
digital organism having a specific genome.
}
\examples{

# Create triplestore object
avidaDB <- triplestore_access$new()

# Set access options
avidaDB$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

# Single genome
get_tandem_id_from_genome_id(genome_id = 1, triplestore = avidaDB)

# More than one genome
get_tandem_id_from_genome_id(
  genome_id = c(1, 2, 3),
  tandem_seq = TRUE,
  triplestore = avidaDB
)

# At seed_1, seed_3 and seed_5
get_tandem_id_from_genome_id(
  genome_id = 2,
  seed_id = c(1, 3, 5),
  tandem_pos = TRUE,
  triplestore = avidaDB
)

}
