% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_prior.R
\name{stsm_prior}
\alias{stsm_prior}
\title{Return a naive model prior decomposition}
\usage{
stsm_prior(y, freq, decomp = "", seasons = NULL, cycle = NULL)
}
\arguments{
\item{y}{an object created from stsm_detect_frequency}

\item{freq}{Frequency of the data}

\item{decomp}{decomposition string}

\item{seasons}{The seasonal periods to split the seasonality into}

\item{cycle}{The cycle periods}
}
\value{
data table containing a naive decomposition using STL
}
\description{
Return a naive model prior decomposition
}
\examples{
\dontrun{
#GDP Not seasonally adjusted
library(autostsm)
data("NA000334Q", package = "autostsm") #From FRED
NA000334Q = data.table(NA000334Q, keep.rownames = TRUE)
colnames(NA000334Q) = c("date", "y")
NA000334Q[, "date" := as.Date(date)]
NA000334Q[, "y" := as.numeric(y)]
NA000334Q = NA000334Q[date >= "1990-01-01", ]
prior = stsm_prior(y = NA000334Q$y, freq = 4)
}
}
