% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_report.R
\name{null_report}
\alias{null_report}
\title{Null report}
\usage{
null_report()
}
\value{
An empty `rtables` object
}
\description{
Null report
}
\details{
This will create a null report similar as STREAM does. You can use
it inside output functions as shown in the example below.
}
\examples{
library(dplyr)
library(filters)
data <- list(
  adsl = eg_adsl,
  adae = eg_adae \%>\% mutate(AREL = "")
)

null_report()

## An example how to use the `null_report()` inside an output function
t_ae <- function(datasets) {
  trt <- "ACTARM"
  anl <- semi_join(
    datasets$adae,
    datasets$adsl,
    by = c("STUDYID", "USUBJID")
  )

  return(null_report())
}

data \%>\%
  filters::apply_filter("SER_SE") \%>\%
  t_ae()

}
\author{
Thomas Neitmann (`neitmant`)
}
